%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      DefineCZPScene.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines a CZP scene which is used primarily to
%                 visualize the affect of aliasing resulting from the sensor
%                 configuration.
%-------------------------------------------------------------------------------

scene = sceneCreate('czp',[],[],waveLengths);

scene = sceneAdjustLuminance(scene,numCandelas);      % Candelas/m2
scene = sceneSet(scene,'distance',distanceToTarget);  % meters
scene = sceneSet(scene,'fov',fieldOfView);            % Field of view in degrees

% It is often useful to visualize the data in the scene window
vcAddAndSelectObject('scene',scene);
if showISET == TRUE,
   sceneWindow;
end

% End of File
